Ext.data.JsonP.sol_common_ix_functions_ChangeRights({"tagname":"class","name":"sol.common.ix.functions.ChangeRights","autodetected":{"aliases":true,"alternateClassNames":true,"extends":true,"mixins":true,"uses":true,"members":true,"code_type":true},"files":[{"filename":"sol.common.ix.functions.ChangeRights.js","href":"sol.common.ix.functions.ChangeRights.html#sol-common-ix-functions-ChangeRights"}],"author":[{"tagname":"author","name":"MW, ELO Digital Office GmbH","email":null}],"version":["1.03.000"],"eloix":true,"requires":["sol.common.AclUtils","sol.common.JsonUtils","sol.common.ObjectFormatter","sol.common.RepoUtils","sol.common.SordUtils","sol.common.Template","sol.common.Utils","sol.common.WfUtils","sol.common.ix.FunctionBase","sol.common.ix.RfUtils"],"aliases":{},"alternateClassNames":[],"extends":"sol.common.ix.FunctionBase","mixins":[],"uses":[],"members":[{"name":"andGroups","tagname":"cfg","owner":"sol.common.ix.functions.ChangeRights","id":"cfg-andGroups","meta":{}},{"name":"cleanup","tagname":"cfg","owner":"sol.common.ix.functions.ChangeRights","id":"cfg-cleanup","meta":{}},{"name":"dontWait","tagname":"cfg","owner":"sol.common.ix.functions.ChangeRights","id":"cfg-dontWait","meta":{}},{"name":"mode","tagname":"cfg","owner":"sol.common.ix.functions.ChangeRights","id":"cfg-mode","meta":{}},{"name":"objId","tagname":"cfg","owner":"sol.common.ix.functions.ChangeRights","id":"cfg-objId","meta":{"required":true}},{"name":"objIds","tagname":"cfg","owner":"sol.common.ix.functions.ChangeRights","id":"cfg-objIds","meta":{}},{"name":"recursive","tagname":"cfg","owner":"sol.common.ix.functions.ChangeRights","id":"cfg-recursive","meta":{}},{"name":"requiredConfig","tagname":"cfg","owner":"sol.common.ix.functions.ChangeRights","id":"cfg-requiredConfig","meta":{"protected":true}},{"name":"rights","tagname":"cfg","owner":"sol.common.ix.functions.ChangeRights","id":"cfg-rights","meta":{}},{"name":"users","tagname":"cfg","owner":"sol.common.ix.functions.ChangeRights","id":"cfg-users","meta":{}},{"name":"wfOwner","tagname":"cfg","owner":"sol.common.ix.functions.ChangeRights","id":"cfg-wfOwner","meta":{}},{"name":"$className","tagname":"property","owner":"sol.Base","id":"property-S-className","meta":{"protected":true}},{"name":"logger","tagname":"property","owner":"sol.common.ix.FunctionBase","id":"property-logger","meta":{"protected":true}},{"name":"$super","tagname":"method","owner":"sol.Base","id":"method-S-super","meta":{"private":true}},{"name":"initialize","tagname":"method","owner":"sol.common.ix.FunctionBase","id":"method-initialize","meta":{"private":true}},{"name":"performBackgroundAclJob","tagname":"method","owner":"sol.common.ix.functions.ChangeRights","id":"method-performBackgroundAclJob","meta":{"private":true}},{"name":"performCleanup","tagname":"method","owner":"sol.common.ix.functions.ChangeRights","id":"method-performCleanup","meta":{"private":true}},{"name":"process","tagname":"method","owner":"sol.common.ix.functions.ChangeRights","id":"method-process","meta":{}},{"name":"RF_sol_contract_function_CreateContractHeadless","tagname":"method","owner":"sol.common.ix.functions.ChangeRights","id":"static-method-RF_sol_contract_function_CreateContractHeadless","meta":{"static":true}},{"name":"RF_sol_contract_function_ExtendDuration","tagname":"method","owner":"sol.common.ix.functions.ChangeRights","id":"static-method-RF_sol_contract_function_ExtendDuration","meta":{"static":true}}],"code_type":"ext_define","id":"class-sol.common.ix.functions.ChangeRights","short_doc":"Changes rights. ...","classIcon":"icon-class","superclasses":["sol.Base","sol.common.ix.FunctionBase"],"subclasses":[],"mixedInto":[],"parentMixins":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/sol.Base' rel='sol.Base' class='docClass'>sol.Base</a><div class='subclass '><a href='#!/api/sol.common.ix.FunctionBase' rel='sol.common.ix.FunctionBase' class='docClass'>sol.common.ix.FunctionBase</a><div class='subclass '><strong>sol.common.ix.functions.ChangeRights</strong></div></div></div><h4>Requires</h4><div class='dependency'><a href='#!/api/sol.common.AclUtils' rel='sol.common.AclUtils' class='docClass'>sol.common.AclUtils</a></div><div class='dependency'><a href='#!/api/sol.common.JsonUtils' rel='sol.common.JsonUtils' class='docClass'>sol.common.JsonUtils</a></div><div class='dependency'><a href='#!/api/sol.common.ObjectFormatter' rel='sol.common.ObjectFormatter' class='docClass'>sol.common.ObjectFormatter</a></div><div class='dependency'><a href='#!/api/sol.common.RepoUtils' rel='sol.common.RepoUtils' class='docClass'>sol.common.RepoUtils</a></div><div class='dependency'><a href='#!/api/sol.common.SordUtils' rel='sol.common.SordUtils' class='docClass'>sol.common.SordUtils</a></div><div class='dependency'><a href='#!/api/sol.common.Template' rel='sol.common.Template' class='docClass'>sol.common.Template</a></div><div class='dependency'>sol.common.Utils</div><div class='dependency'><a href='#!/api/sol.common.WfUtils' rel='sol.common.WfUtils' class='docClass'>sol.common.WfUtils</a></div><div class='dependency'><a href='#!/api/sol.common.ix.FunctionBase' rel='sol.common.ix.FunctionBase' class='docClass'>sol.common.ix.FunctionBase</a></div><div class='dependency'><a href='#!/api/sol.common.ix.RfUtils' rel='sol.common.ix.RfUtils' class='docClass'>sol.common.ix.RfUtils</a></div><h4>Files</h4><div class='dependency'><a href='source/sol.common.ix.functions.ChangeRights.html#sol-common-ix-functions-ChangeRights' target='_blank'>sol.common.ix.functions.ChangeRights.js</a></div></pre><div class='doc-contents'><p>Changes rights.</p>\n\n<p>Add rights based on a configuration. It can also perform a cleanup before setting the new rights.</p>\n\n<h1>Node configuration example:</h1>\n\n<pre><code>{\n  \"users\": [\"user1\"],      // user1 will get\n  \"rights\": { \"r\": true }, // read access\n  \"mode\": \"SET\"            // while all other rights will be removed\n}\n\n{\n  \"users\": [\"group2\"],     // group2 will get\n  \"rights\": { \"w\": true }, // write access\n  \"mode\": \"ADD\"            // in addition to the other (already existing) rights\n}\n</code></pre>\n\n<p>Without configuration the current user will get full rights for the given\nobject and it's children.</p>\n\n<h1>Extended configuration:</h1>\n\n<pre><code>{\n  \"users\": [\n    { \"name\": \"Mustermann\" },                                          // user 'Mustermann' gets the fallback rights\n    { \"name\": \"Haenschenklein\", \"rights\": { \"r\": true, \"w\": true } },  // user 'Haenschenklein' gets read and write access\n    { \"type\": \"GRP\", \"key\": \"MY_USER\" }                                // if there is a user configured in index field 'MY_USER', it gets the fallback rights\n  ],\n  \"andGroups\": [\n    { \"groups\": [\"GroupA\", \"GroupB\", { \"type\": \"GRP\", \"key\": \"CONTRACT_RESPONSIBLE\" }] }, // and-group (containing three groups) with fallback rights\n    { \"groups\": [\"GroupX\", \"GroupY\"], \"rights\": { \"r\": true, \"w\": true, \"l\": true } }         // and-group (containing two groups) with read, write and list access\n  ],\n  \"rights\": { \"r\": true }\n}\n</code></pre>\n\n<h1>Cleanup</h1>\n\n<p>This function can also perform a cleanup (see <a href=\"#!/api/sol.common.ix.functions.ChangeRights-cfg-cleanup\" rel=\"sol.common.ix.functions.ChangeRights-cfg-cleanup\" class=\"docClass\">cleanup</a>).\nIf new rights are configured, this cleanup step will be performed before the new rights will be set.</p>\n\n<p>The following example will remove the 'delete' permission for user 'kraft' and add 'read' permission for user 'renz':</p>\n\n<pre><code>{\n  \"users\": [\n    \"renz\"\n  ],\n  \"cleanup\": {\n    \"users\": [\n      { \"name\": \"kraft\", \"rights\": { \"d\": true } }\n    ]\n  },\n  \"rights\": { \"r\": true }\n}\n</code></pre>\n      <p class='version-tag'>Version: <b>1.03.000</b></p>\n</div><div class='members'><div class='members-section'><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Required config options</h3><div id='cfg-objId' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.ChangeRights'>sol.common.ix.functions.ChangeRights</span><br/><a href='source/sol.common.ix.functions.ChangeRights.html#sol-common-ix-functions-ChangeRights-cfg-objId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.ChangeRights-cfg-objId' class='name expandable'>objId</a> : String<span class=\"signature\"><span class='required' >required</span></span></div><div class='description'><div class='short'>\n</div><div class='long'>\n<p>Overrides: <a href=\"#!/api/sol.common.ix.FunctionBase-cfg-objId\" rel=\"sol.common.ix.FunctionBase-cfg-objId\" class=\"docClass\">sol.common.ix.FunctionBase.objId</a></p></div></div></div></div><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Optional config options</h3><div id='cfg-andGroups' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.ChangeRights'>sol.common.ix.functions.ChangeRights</span><br/><a href='source/sol.common.ix.functions.ChangeRights.html#sol-common-ix-functions-ChangeRights-cfg-andGroups' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.ChangeRights-cfg-andGroups' class='name expandable'>andGroups</a> : Object[]<span class=\"signature\"></span></div><div class='description'><div class='short'>An array with and-group definitions. ...</div><div class='long'><p>An array with and-group definitions.\nSee <a href=\"#!/api/sol.common.AclUtils-method-changeRightsInBackground\" rel=\"sol.common.AclUtils-method-changeRightsInBackground\" class=\"docClass\">changeRightsInBackground</a></p>\n</div></div></div><div id='cfg-cleanup' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.ChangeRights'>sol.common.ix.functions.ChangeRights</span><br/><a href='source/sol.common.ix.functions.ChangeRights.html#sol-common-ix-functions-ChangeRights-cfg-cleanup' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.ChangeRights-cfg-cleanup' class='name expandable'>cleanup</a> : Object<span class=\"signature\"></span></div><div class='description'><div class='short'>Configuration of a cleanup, before the new rights will be applied ...</div><div class='long'><p>Configuration of a cleanup, before the new rights will be applied</p>\n<ul><li><span class='pre'>users</span> : String[]|Object[]<div class='sub-desc'><p>Specifies, which users rights will be removed (see <a href=\"#!/api/sol.common.AclUtils-method-changeRightsInBackground\" rel=\"sol.common.AclUtils-method-changeRightsInBackground\" class=\"docClass\">changeRightsInBackground</a>).</p>\n</div></li><li><span class='pre'>revokeWfOwnerRights</span> : Boolean<div class='sub-desc'><p>If <code>true</code> and the property <code>wfOwner</code> is set, <code>wfOwner</code> loses all access rights</p>\n</div></li><li><span class='pre'>rights</span> : Object<div class='sub-desc'><p>Specifies, which rights will be removed in case the user object does not state otherwise (see <a href=\"#!/api/sol.common.AclUtils-method-changeRightsInBackground\" rel=\"sol.common.AclUtils-method-changeRightsInBackground\" class=\"docClass\">changeRightsInBackground</a>). If nothing is set, all rights will be removed.</p>\n</div></li></ul></div></div></div><div id='cfg-dontWait' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.ChangeRights'>sol.common.ix.functions.ChangeRights</span><br/><a href='source/sol.common.ix.functions.ChangeRights.html#sol-common-ix-functions-ChangeRights-cfg-dontWait' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.ChangeRights-cfg-dontWait' class='name expandable'>dontWait</a> : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'><p>See <a href=\"#!/api/sol.common.AclUtils-method-changeRightsInBackground\" rel=\"sol.common.AclUtils-method-changeRightsInBackground\" class=\"docClass\">changeRightsInBackground</a></p>\n</div><div class='long'><p>See <a href=\"#!/api/sol.common.AclUtils-method-changeRightsInBackground\" rel=\"sol.common.AclUtils-method-changeRightsInBackground\" class=\"docClass\">changeRightsInBackground</a></p>\n</div></div></div><div id='cfg-mode' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.ChangeRights'>sol.common.ix.functions.ChangeRights</span><br/><a href='source/sol.common.ix.functions.ChangeRights.html#sol-common-ix-functions-ChangeRights-cfg-mode' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.ChangeRights-cfg-mode' class='name expandable'>mode</a> : String<span class=\"signature\"></span></div><div class='description'><div class='short'><p>See <a href=\"#!/api/sol.common.AclUtils-method-changeRightsInBackground\" rel=\"sol.common.AclUtils-method-changeRightsInBackground\" class=\"docClass\">changeRightsInBackground</a></p>\n</div><div class='long'><p>See <a href=\"#!/api/sol.common.AclUtils-method-changeRightsInBackground\" rel=\"sol.common.AclUtils-method-changeRightsInBackground\" class=\"docClass\">changeRightsInBackground</a></p>\n</div></div></div><div id='cfg-objIds' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.ChangeRights'>sol.common.ix.functions.ChangeRights</span><br/><a href='source/sol.common.ix.functions.ChangeRights.html#sol-common-ix-functions-ChangeRights-cfg-objIds' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.ChangeRights-cfg-objIds' class='name expandable'>objIds</a> : String<span class=\"signature\"></span></div><div class='description'><div class='short'>If the processing should be executed on more then one element. ...</div><div class='long'><p>If the processing should be executed on more then one element. <code>objId</code> is still required, as base for the data.</p>\n</div></div></div><div id='cfg-recursive' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.ChangeRights'>sol.common.ix.functions.ChangeRights</span><br/><a href='source/sol.common.ix.functions.ChangeRights.html#sol-common-ix-functions-ChangeRights-cfg-recursive' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.ChangeRights-cfg-recursive' class='name expandable'>recursive</a> : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'><p>See <a href=\"#!/api/sol.common.AclUtils-method-changeRightsInBackground\" rel=\"sol.common.AclUtils-method-changeRightsInBackground\" class=\"docClass\">changeRightsInBackground</a></p>\n</div><div class='long'><p>See <a href=\"#!/api/sol.common.AclUtils-method-changeRightsInBackground\" rel=\"sol.common.AclUtils-method-changeRightsInBackground\" class=\"docClass\">changeRightsInBackground</a></p>\n</div></div></div><div id='cfg-requiredConfig' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.ChangeRights'>sol.common.ix.functions.ChangeRights</span><br/><a href='source/sol.common.ix.functions.ChangeRights.html#sol-common-ix-functions-ChangeRights-cfg-requiredConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.ChangeRights-cfg-requiredConfig' class='name expandable'>requiredConfig</a> : Array<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>List of required config properties. ...</div><div class='long'><p>List of required config properties. <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a> throws an exception if one of the properties is null or undefined.</p>\n<p>Defaults to: <code>[&quot;objId&quot;]</code></p><p>Overrides: <a href=\"#!/api/sol.Base-cfg-requiredConfig\" rel=\"sol.Base-cfg-requiredConfig\" class=\"docClass\">sol.Base.requiredConfig</a></p></div></div></div><div id='cfg-rights' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.ChangeRights'>sol.common.ix.functions.ChangeRights</span><br/><a href='source/sol.common.ix.functions.ChangeRights.html#sol-common-ix-functions-ChangeRights-cfg-rights' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.ChangeRights-cfg-rights' class='name expandable'>rights</a> : Object<span class=\"signature\"></span></div><div class='description'><div class='short'>Rights that will be set to the workflow object and it's children. ...</div><div class='long'><p>Rights that will be set to the workflow object and it's children.\nSee <a href=\"#!/api/sol.common.AclUtils-method-changeRightsInBackground\" rel=\"sol.common.AclUtils-method-changeRightsInBackground\" class=\"docClass\">changeRightsInBackground</a></p>\n</div></div></div><div id='cfg-users' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.ChangeRights'>sol.common.ix.functions.ChangeRights</span><br/><a href='source/sol.common.ix.functions.ChangeRights.html#sol-common-ix-functions-ChangeRights-cfg-users' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.ChangeRights-cfg-users' class='name expandable'>users</a> : String[]|Object[]<span class=\"signature\"></span></div><div class='description'><div class='short'>Specifies, which users rights will be altered (see sol.common.AclUtils and especially changeRightsInBackground). ...</div><div class='long'><p>Specifies, which users rights will be altered (see <a href=\"#!/api/sol.common.AclUtils\" rel=\"sol.common.AclUtils\" class=\"docClass\">sol.common.AclUtils</a> and especially <a href=\"#!/api/sol.common.AclUtils-method-changeRightsInBackground\" rel=\"sol.common.AclUtils-method-changeRightsInBackground\" class=\"docClass\">changeRightsInBackground</a>).\nAdditionally the user object can have a <code>type</code> and a <code>key</code> property (see <a href=\"#!/api/sol.common.SordUtils-method-getValue\" rel=\"sol.common.SordUtils-method-getValue\" class=\"docClass\">sol.common.SordUtils.getValue</a>), which will be used to determine the user name.</p>\n</div></div></div><div id='cfg-wfOwner' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.ChangeRights'>sol.common.ix.functions.ChangeRights</span><br/><a href='source/sol.common.ix.functions.ChangeRights.html#sol-common-ix-functions-ChangeRights-cfg-wfOwner' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.ChangeRights-cfg-wfOwner' class='name expandable'>wfOwner</a> : String<span class=\"signature\"></span></div><div class='description'><div class='short'>This attribute will be used, if the cleanup specifies to remove rights of the wfOwner. ...</div><div class='long'><p>This attribute will be used, if the cleanup specifies to remove rights of the <code>wfOwner</code>.\nIf this function is used in a workflow, this will be set automatically.</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-S-className' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-S-className' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-S-className' class='name expandable'>$className</a> : Object<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>{String}\nname of the class including its namespace.</p>\n</div><div class='long'><p>{String}\nname of the class including its namespace.</p>\n</div></div></div><div id='property-logger' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ix.FunctionBase' rel='sol.common.ix.FunctionBase' class='defined-in docClass'>sol.common.ix.FunctionBase</a><br/><a href='source/lib_sol.common.ix.FunctionBase.html#sol-common-ix-FunctionBase-property-logger' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.FunctionBase-property-logger' class='name expandable'>logger</a> : <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a><span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>The logger for the module</p>\n</div><div class='long'><p>The logger for the module</p>\n<p>Overrides: <a href=\"#!/api/sol.Base-property-logger\" rel=\"sol.Base-property-logger\" class=\"docClass\">sol.Base.logger</a></p></div></div></div></div></div><div class='members-section'><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Instance methods</h3><div id='method-S-super' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-S-super' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-S-super' class='name expandable'>$super</a>( <span class='pre'>superClassName, functionName, arguments</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Calls a function of a superclass thanks to its name. ...</div><div class='long'><p>Calls a function of a superclass thanks to its name. Superclass must be part of the calling objects class hierarchy.</p>\n\n<p><b>Please note that calling superclass functions might lead to an infinitive loop if misused. Please validate that none class other than the classes superclass is passed as the superclass parent.</b></p>\n\n<pre><code>me.$super(superClassName, functionName, attributesArray);\n</code></pre>\n\n<p>A basic example of the initialize-function will look as followed.</p>\n\n<pre><code>me.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", [config]);\nme.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", arguments);\n</code></pre>\n\n<p>A word on performance: The superclass name must be passed since the js rhino engine does not allow accessing the caller of the callee due to performance reasons.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>superClassName</span> : String<div class='sub-desc'><p>name of the super class.</p>\n</div></li><li><span class='pre'>functionName</span> : String<div class='sub-desc'><p>name of the function that should be called.</p>\n</div></li><li><span class='pre'>arguments</span> : Object[]<div class='sub-desc'><p>list of arguments that should be passed to the function.</p>\n</div></li></ul></div></div></div><div id='method-initialize' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ix.FunctionBase' rel='sol.common.ix.FunctionBase' class='defined-in docClass'>sol.common.ix.FunctionBase</a><br/><a href='source/lib_sol.common.ix.FunctionBase.html#sol-common-ix-FunctionBase-method-initialize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.FunctionBase-method-initialize' class='name expandable'>initialize</a>( <span class='pre'>config</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Initialize class. ...</div><div class='long'><p>Initialize class.\nThis function is called after the class was instantiated.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>parameters as defined. See documentation for more details.</p>\n</div></li></ul><p>Overrides: <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a></p></div></div></div><div id='method-performBackgroundAclJob' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.ChangeRights'>sol.common.ix.functions.ChangeRights</span><br/><a href='source/sol.common.ix.functions.ChangeRights.html#sol-common-ix-functions-ChangeRights-method-performBackgroundAclJob' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.ChangeRights-method-performBackgroundAclJob' class='name expandable'>performBackgroundAclJob</a>( <span class='pre'>rightsConfig</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Performs the background job to change the rights. ...</div><div class='long'><p>Performs the background job to change the rights.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>rightsConfig</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-performCleanup' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.ChangeRights'>sol.common.ix.functions.ChangeRights</span><br/><a href='source/sol.common.ix.functions.ChangeRights.html#sol-common-ix-functions-ChangeRights-method-performCleanup' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.ChangeRights-method-performCleanup' class='name expandable'>performCleanup</a>( <span class='pre'></span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Uses changeRightsInBackground to remove specific user rights. ...</div><div class='long'><p>Uses <a href=\"#!/api/sol.common.AclUtils-method-changeRightsInBackground\" rel=\"sol.common.AclUtils-method-changeRightsInBackground\" class=\"docClass\">changeRightsInBackground</a> to remove specific user rights.</p>\n</div></div></div><div id='method-process' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.ChangeRights'>sol.common.ix.functions.ChangeRights</span><br/><a href='source/sol.common.ix.functions.ChangeRights.html#sol-common-ix-functions-ChangeRights-method-process' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.ChangeRights-method-process' class='name expandable'>process</a>( <span class='pre'></span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Adds rights to an object or branch. ...</div><div class='long'><p>Adds rights to an object or branch.</p>\n<p>Overrides: <a href=\"#!/api/sol.common.ix.FunctionBase-method-process\" rel=\"sol.common.ix.FunctionBase-method-process\" class=\"docClass\">sol.common.ix.FunctionBase.process</a></p></div></div></div></div><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Static methods</h3><div id='static-method-RF_sol_contract_function_CreateContractHeadless' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.ChangeRights'>sol.common.ix.functions.ChangeRights</span><br/><a href='source/sol.contract.ix.functions.CreateContractHeadless.html#sol-common-ix-functions-ChangeRights-static-method-RF_sol_contract_function_CreateContractHeadless' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.ChangeRights-static-method-RF_sol_contract_function_CreateContractHeadless' class='name expandable'>RF_sol_contract_function_CreateContractHeadless</a>( <span class='pre'>Execution, args</span> )<span class=\"signature\"><span class='static' >static</span></span></div><div class='description'><div class='short'>This function can be called from an application by invoking the API function \"executeRegisteredFunction\" or by using\n...</div><div class='long'><p>This function can be called from an application by invoking the API function \"executeRegisteredFunction\" or by using\n<a href=\"#!/api/sol.common.IxUtils-method-execute\" rel=\"sol.common.IxUtils-method-execute\" class=\"docClass\">sol.common.IxUtils.execute</a> which internally handles the Any-Object conversion.</p>\n\n<p>All configuration params should be passed as a configuration object to the args param.</p>\n\n<pre><code><a href=\"#!/api/sol.common.IxUtils-method-execute\" rel=\"sol.common.IxUtils-method-execute\" class=\"docClass\">sol.common.IxUtils.execute</a>('RF_FunctionName', {\n  configParam1: 'myParam'\n});\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>Execution</span> : de.elo.ix.client.IXServerEventsContext<div class='sub-desc'><p>context</p>\n\n\n\n</div></li><li><span class='pre'>args</span> : Object<div class='sub-desc'><p>Argument array sent by the client application.</p>\n\n\n\n</div></li></ul></div></div></div><div id='static-method-RF_sol_contract_function_ExtendDuration' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.ChangeRights'>sol.common.ix.functions.ChangeRights</span><br/><a href='source/sol.contract.ix.functions.ExtendDuration.html#sol-common-ix-functions-ChangeRights-static-method-RF_sol_contract_function_ExtendDuration' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.ChangeRights-static-method-RF_sol_contract_function_ExtendDuration' class='name expandable'>RF_sol_contract_function_ExtendDuration</a>( <span class='pre'>Execution, args</span> )<span class=\"signature\"><span class='static' >static</span></span></div><div class='description'><div class='short'>This function can be called from an application by invoking the API function \"executeRegisteredFunction\" or by using\n...</div><div class='long'><p>This function can be called from an application by invoking the API function \"executeRegisteredFunction\" or by using\n<a href=\"#!/api/sol.common.IxUtils-method-execute\" rel=\"sol.common.IxUtils-method-execute\" class=\"docClass\">sol.common.IxUtils.execute</a> which internally handles the Any-Object conversion.</p>\n\n<p>All configuration params should be passed as a configuration object to the args param.</p>\n\n<pre><code><a href=\"#!/api/sol.common.IxUtils-method-execute\" rel=\"sol.common.IxUtils-method-execute\" class=\"docClass\">sol.common.IxUtils.execute</a>('RF_FunctionName', {\n  configParam1: 'myParam'\n});\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>Execution</span> : de.elo.ix.client.IXServerEventsContext<div class='sub-desc'><p>context</p>\n\n\n\n</div></li><li><span class='pre'>args</span> : Object<div class='sub-desc'><p>Argument array sent by the client application.</p>\n\n\n\n</div></li></ul></div></div></div></div></div></div></div>","meta":{"eloix":true}});